---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.4
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 16, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 092900 Added pkg_ALKINDI_SEARCH.sp_SEL_Movie_Advance to search for product_ids based upon movie criteria
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 101300 Corrected pkg_ALKINDI_SEARCH.sp_SEL_Movie_Simple 
-- AHW 101300 Added comments to stored procedures
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_SEARCH
AS
  TYPE SEARCH_cursor_type is REF CURSOR;

  PROCEDURE sp_SEL_UserID_By_Screenname(
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Simple(
	i_FIELD			IN		VARCHAR2,
	i_CRITERIA			IN		VARCHAR2,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Advance(
	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

END pkg_ALKINDI_SEARCH;
/

-- ==========================================================================================

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_SEARCH
AS

  PROCEDURE sp_SEL_UserID_By_Screenname(						-- Search for USER_IDs that have a Screenname similar to the one submitted

	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
  IS 
	v_SEARCH_CRITERIA VARCHAR2(17);
  BEGIN
	o_ERROR_CODE	:= 0;
	v_SEARCH_CRITERIA	:= '%'||i_SCREENNAME||'%';

	OPEN o_SEARCH_cursor_type FOR
	SELECT USER_ID
	     , SCREENNAME
	  FROM USER_DETAIL
	 WHERE UPPER(SCREENNAME) LIKE UPPER(v_SEARCH_CRITERIA);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6565;
		CLOSE o_SEARCH_cursor_type;
 END sp_SEL_UserID_By_Screenname;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Simple(

-- A simple search for movies by field and criteria

	i_FIELD			IN		VARCHAR2,
	i_CRITERIA			IN		VARCHAR2,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS 
	v_SQL VARCHAR2(1000) ;
   BEGIN

	o_ERROR_CODE	:= 0;

	v_SQL :='SELECT PRODUCT_ID FROM MOVIE WHERE UPPER('
		||i_FIELD
		||') LIKE UPPER('
		||''''
		||'%'
		|| i_CRITERIA
		||'%'
		||''''
		||')';

	OPEN o_SEARCH_cursor_type FOR v_SQL;

 EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_SEARCH_cursor_type;
 END sp_SEL_Movie_Simple;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Advance(

-- An advanced search for movies by title, movie_description, actor and director 

	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

  IS 
	v_SEARCH_TITLE		 VARCHAR2(2000);
	v_SEARCH_MOVIE_DESC	 VARCHAR2(2000);
	v_SEARCH_ACTOR		 VARCHAR2(2000);
	v_SEARCH_DIRECTOR		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_TITLE		:= '%'||i_TITLE||'%';
	v_SEARCH_MOVIE_DESC	:= '%'||i_MOVIE_DESC||'%';
	v_SEARCH_ACTOR		:= '%'||i_ACTOR||'%';
	v_SEARCH_DIRECTOR		:= '%'||i_DIRECTOR||'%';

	OPEN o_SEARCH_cursor_type FOR
	SELECT PRODUCT_ID
	  FROM MOVIE
	 WHERE UPPER(TITLE)		LIKE UPPER(v_SEARCH_TITLE)
	   AND UPPER(MOVIE_DESC)	LIKE UPPER(v_SEARCH_MOVIE_DESC)
	   AND UPPER(ACTOR)		LIKE UPPER(v_SEARCH_ACTOR)
	   AND UPPER(DIRECTOR)		LIKE UPPER(v_SEARCH_DIRECTOR);

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6567;						-- general errors when performing advanced search for movies
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_Advance;

-- ==========================================================================================

END pkg_ALKINDI_SEARCH;
/

SHOW ERRORS
